<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\helpers\AdminHelper;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
ToolBar::setTitle("List currency");
$input = FactoryAlias::getInput();
$user_id = $input->getInt('user_id',0);

$check_user_demo = AdminHelper::checkUserDemo();
$uploads = wp_upload_dir();

$appConfig = FactoryAlias::getAppConfig();
$default_currency = $appConfig->get('default_currency','');

?>
<?php ?>
    <form action="" name="admin-form" method="post">
        <div class="view-list-currency">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="view-list-currency-th nowrap"><?php esc_html_e('Name','wpbookingpro')?></th>
                        <th class="view-list-currency-th nowrap"><?php esc_html_e('Currency','wpbookingpro')?></th>
                        <th class="view-list-currency-th nowrap"><?php esc_html_e('Symbol','wpbookingpro')?></th>
                        <th class="view-list-currency-th nowrap"><?php esc_html_e('Exchange rate','wpbookingpro')?></th>
                        <th class="view-list-currency-th nowrap"><?php esc_html_e('Default currency','wpbookingpro')?></th>
                        <th class="view-list-currency-th nowrap"><?php esc_html_e('Published','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php echo (esc_html($item->name)); ?></td>
                        <td class="currency nowrap"><?php echo (esc_html($item->unit_currency)); ?></td>
                        <td class="symbol nowrap"><?php echo (esc_html($item->symbol_currency)); ?></td>
                        <td class="exchange-rate nowrap">
                            <?php
                            echo (esc_html(AdminHelper::getExchangeRate($item->unit_currency)))
                            ?>
                        </td>
                        <td class="default-currency nowrap"><?php echo (esc_html($default_currency)); ?></td>
                        <td class="publish nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookingpro');?>"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not published','wpbookingpro');?>"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="state-action">
                            <a href="<?php echo($this->permission?UtilityAlias::getBackendGoToLink("currency.form",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-edit"></i></a>
                            <a href="<?php echo($this->permission?UtilityAlias::goToTaskByView("currency","currency.delete",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?> ><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_currency.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-currency', 'view_list_currency', array(

), "admin/app/assets/js/view_list_currency.js");
?>