<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\helpers\AdminHelper;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
ToolBar::setTitle("List coupon");
$input = FactoryAlias::getInput();
$user_id = $input->getInt('user_id',0);

$check_user_demo = AdminHelper::checkUserDemo();
$uploads = wp_upload_dir();

?>
<?php ?>
    <form action="" name="admin-form" method="post">
        <div class="view-list-coupon">
            <div class="row">
                <div class="col-md-3">
                    <h5><?php esc_html_e('Filter by vendor','wpbookingpro');?></h5>
                    <select  id="searchByVendor" name="user_id">
                        <option value=''>-- <?php esc_html_e('Select vendor','wpbookingpro');?>--</option>
                        <?php foreach ($this->list_vendor as $vendor_item) {?>
                            <option value="<?php echo (esc_attr($vendor_item->id)) ?>" <?php echo (esc_attr($user_id == $vendor_item->id ? 'selected':''))?> >
                                <?php echo (esc_html(UtilityAlias::get_full_name($vendor_item->first_name, $vendor_item->last_name)))?>
                            </option>
                        <?php }?>
                    </select>
                </div>
            </div>
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="view-list-coupon-th nowrap"><?php esc_html_e('Name','wpbookingpro')?></th>
                        <th class="view-list-coupon-th nowrap"><?php esc_html_e('Code','wpbookingpro')?></th>
                        <th class="view-list-coupon-th nowrap"><?php esc_html_e('Service','wpbookingpro')?></th>
                        <th class="view-list-coupon-th nowrap"><?php esc_html_e('Vendor','wpbookingpro')?></th>
                        <th class="view-list-coupon-th nowrap"><?php esc_html_e('Amount','wpbookingpro')?></th>
                        <th class="view-list-coupon-th nowrap"><?php esc_html_e('Percent','wpbookingpro')?></th>
                        <th class="view-list-coupon-th nowrap"><?php esc_html_e('Published','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php echo (esc_html($item->name)); ?></td>
                        <td class="name nowrap"><?php echo (esc_html($item->code)); ?></td>
                        <td class="service-name">
                            <?php foreach ($item->list_service as $service){ ?>
                                <?php echo "$service->name <br/>" ?>
                            <?php } ?>
                        </td>
                        <td class="nowrap">
                            <?php echo (esc_html(isset($item->vendor)?UtilityAlias::get_full_name($item->vendor->first_name, $item->vendor->last_name):'None'))?>
                        </td>

                        <td class="name nowrap"><?php echo (esc_html($item->amount)); ?></td>
                        <td class="name nowrap"><?php echo (esc_html($item->percent)); ?></td>
                        <td class="nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookingpro');?>"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not published','wpbookingpro');?>"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="state-action">
                            <a href="<?php echo($this->permission?UtilityAlias::getBackendGoToLink("coupon.form",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-edit"></i></a>
                            <a href="<?php echo($this->permission?UtilityAlias::goToTaskByView("coupon","coupon.delete",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?> ><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>