<?php

namespace WpBookingProAdmin\app\views\activities;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;

class ActivitiesView extends View
{
    public function display($tpl)
    {
        $modelActivity = Model::getInstance("activity");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("activity.add");
                ToolBar::delete("activity.delete_list");
                ToolBar::_clone("activity.clone_list");
                $model = Model::getInstance("activities");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit Activity');
                ToolBar::apply("activity.apply");
                ToolBar::save("activity.save");
                ToolBar::cancel("activity.cancel");
                ToolBar::back_to_list("activity.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelActivity->getItem($id);
                $this->form = $modelActivity->getForm();

                break;
        }
        return parent::display($tpl);
    }
}