<?php
namespace WpBookingProAdmin\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;

class WishlistsModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "wishlists";
    /**
     * @var string
     */
    public $table_name = "wishlist";

    public function getList()
    {
        $list =  parent::getList(); // TODO: Change the autogenerated stub
        $query = $this->_db->getQuery(true);
        foreach ($list as &$item) {
            $query->clear()
                ->select('name')
                ->from($this->getTableName('service'))
                ->where('id='.(int)$item->service_id)
            ;
            $item->service_name = $this->_db->setQuery($query)->loadResult();

            $query->clear()
                ->select('*')
                ->from($this->getTableName('user'))
                ->where('id='.(int)$item->user_id)
            ;
            $user = $this->_db->setQuery($query)->loadObject();
            $item->user_name = Utility::get_full_name(isset($user->first_name)?$user->first_name:'', isset($user->last_name)?$user->last_name:'');
        }
        return $list;
    }

}
