<?php
namespace WpBookingProAdmin\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
class StatesModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "states";
    /**
     * @var string
     */
    public $table_name = "state";
    public function getListQuery()
    {
        $input = Factory::getInput();
        $user_id  = $input->getInt('user_id',0);
        $query = $this->_db->getQuery(true);
        $query->clear()
            ->select('a.*')
            ->from($this->getTableName() . ' AS a')
            ->leftJoin($this->getTableName('country') . ' AS country ON country.id =a.country_id')
            ->select('country.countryname  AS country_name');

        if($user_id > 0) {
            $query->where('a.user_id='.(int)$user_id);
        }
        $query->order($this->getState('list.ordering', 'a.ordering') . ' ' . $this->getState('list.direction', 'ASC'));
        return $query;
    }

    public function getList()
    {
        $db=Factory::getDBO();
        $query=$this->getListQuery();

        return $db->setQuery($query)->loadObjectList();
    }


}
