<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelvendor = Model::getInstance('vendors');
$list = $modelvendor->getListVendor();
$list_time = [];
$list_vendor_id = [];
if (!is_array($value)) {
	$list_vendor_id[] = $value;
} else {
	$list_vendor_id = $value;
}
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-vendor">
        <select name="<?php echo (esc_attr($name)); ?>"
                required="<?php echo (esc_attr($required)) ?>" <?php echo (esc_attr($multiple ? ' multiple ' : "")); ?>
                class="list-vendor">
            <option value=""><?php esc_html_e('Select vendor','wpbookingpro') ?></option>
			<?php foreach ($list as $item) { ?>
                <option <?php  echo (esc_attr(in_array($item->id, $list_vendor_id) ? ' selected ' : null)) ?>
                        value="<?php echo (esc_attr($item->id)); ?>"><?php echo (esc_html(Utility::get_full_name($item->first_name, $item->last_name))); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-vendor','field_vendor',array(
),'admin/app/layouts/WooBooking/form/field/vendor/vendor.jquery.js');