<?php
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$list_unitforsearch = array('Km','Mi');

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>"
         class="<?php echo (esc_attr($class)); ?> field-unitforsearch-<?php echo (esc_attr($name_format)) ?> field-unitforsearch">
        <select class="form-control list-unitforsearch" <?php echo ($multiple ? ' multiple ' : ""); ?>>
            <option value=""> <?php esc_html_e('Select unit for search','wpbookingpro') ?></option>
			<?php foreach ($list_unitforsearch as $unitforsearch) { ?>
                <option <?php echo ($unitforsearch == $value ? " selected " : "") ?>
                        value="<?php echo (esc_attr($unitforsearch)); ?>"><?php echo (esc_html($unitforsearch)); ?></option>
			<?php } ?>
        </select>
        <input type="hidden" name="<?php echo (esc_attr($name)); ?>">
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-unitforsearch','field_unitforsearch',array(
    "field_name"=>  $name,
    "value"=> $value
),'admin/app/layouts/WooBooking/form/field/unitforsearch/unitforsearch.jquery.js');
