"use strict";
(function ($) {
    $.field_unitforsearch = function (element, options) {
        var defaults = {
            field_name: "",
            value:''
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('select.list-unitforsearch').select2();
            let value = plugin.settings.value;
            let field_name = plugin.settings.field_name;
            $element.find(`input[name="${field_name}"]`).val(value);
            $element.find('select.list-unitforsearch').on('change', function (e) {
                let val = $(this).val();
                $element.find(`input[name="${field_name}"]`).val(val);
            })
        };
        plugin.getValue = function () {
            let field_name = plugin.settings.field_name;
            return $element.find(`select[name="${field_name}"]`).val();
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.field_unitforsearch = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('field_unitforsearch')) {
                var plugin = new $.field_unitforsearch(this, options);
                $(this).data('field_unitforsearch', plugin);
            }
        });
    }
})(jQuery);