<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$list_type_field = array('boolean','text','textarea','editor');

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-typefield">
        <select class="table-view" name="<?php echo (esc_attr($name)); ?>">
            <option value=""><?php esc_html_e('Select type','wpbookingpro') ?></option>
            <?php foreach ($list_type_field as $type) { ?>
                <option <?php echo ($value == $type ? ' selected ' : '') ?>
                        value="<?php echo (esc_attr($type)) ?>"><?php esc_html_e(ucfirst($type),'wpbookingpro') ?></option>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-typefield','field_typefield',array(
),'admin/app/layouts/WooBooking/form/field/typefield/typefield.jquery.js');