<?php
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$timezoneModel = Model::getInstance('timezones');
$list_timezone = $timezoneModel->getList();

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>"
         class="<?php echo (esc_attr($class)); ?> field-timezone-<?php echo (esc_attr($name_format)) ?> field-timezone">
        <select class="form-control list-timezone" <?php echo ($multiple ? ' multiple ' : ""); ?>>
            <option value=""> <?php esc_html_e('Select timezone','wpbookingpro') ?></option>
			<?php foreach ($list_timezone as $timezone) { ?>
                <option <?php echo ($timezone->timezone == $value ? " selected " : "") ?>
                        value="<?php echo (esc_attr($timezone->timezone)); ?>"><?php echo (esc_html($timezone->timezone)); ?></option>
			<?php } ?>
        </select>
        <input type="hidden" name="<?php echo (esc_attr($name)); ?>">
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-timezone','field_timezone',array(
    "field_name"=>  $name,
    "value"=> $value
),'admin/app/layouts/WooBooking/form/field/timezone/timezone.jquery.js');
