<?php
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_". $name;
$name_format = str_replace(array('[', ']'), '_', $name);
$seasonsModel = Model::getInstance('seasons');
$list_seasons = $seasonsModel->getList_season_public();

$list_selected = is_array($value) ? $value : array();

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>"
         class="<?php echo (esc_attr($class)); ?> field-seasons-<?php echo (esc_attr($name_format)) ?> field-seasons">
        <select name="<?php echo (esc_attr($name)); ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                class="form-control list-seasons">
            <option value=""> <?php esc_html_e('Select seasons','wpbookingpro') ?></option>
			<?php foreach ($list_seasons as $season) { ?>
                <option <?php echo (in_array($season->id, $list_selected) ? " selected " : "") ?>
                        value="<?php echo (esc_attr($season->id)); ?>"><?php echo (esc_html($season->name)); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-seasons','field_seasons',array(
    "field_name"=>  $name,
),'admin/app/layouts/WooBooking/form/field/seasons/seasons.jquery.js');
