"use strict";
(function ($) {
    $.field_rolesetup = function (element, options) {
        var defaults = {
            field_name: "",
            value:''
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let field_name = plugin.settings.field_name;
            let role_user = plugin.settings.value;
            $element.find(".checked-all").on('change',function(){
                let $role_item = $(this).closest('.role-item');
                let permission_detail = [];
                if(this.checked){
                    $role_item.find(".checked-single").each(function(index, item){
                        this.checked=true;
                        $role_item.find('.role-edit').prop('disabled', false);
                        permission_detail.push($(item).val())
                    });
                    role_user[`${$(this).val()}`] = permission_detail;
                }else{
                    $role_item.find(".checked-single").each(function(){
                        this.checked=false;
                        $role_item.find('.role-edit').prop('disabled', true);
                    });
                    delete role_user[`${$(this).val()}`];
                }
                $element.find(`input[name="${field_name}"]`).val(JSON.stringify(role_user));
            });
            $element.find(".checked-single").on('change',function () {
                let $role_item = $(this).closest('.role-item');
                let permission = $role_item.find("input.checked-all").val();
                let permission_detail = [];
                $role_item.find('input.checked-single').each(function (index, item) {
                    if($(item).is(':checked')) {
                        permission_detail.push($(item).val())
                    }
                });
                if ($(this).is(":checked")) {
                    var val = $(this).val();
                    permission_detail.push(val);
                    permission_detail = plugin.remove_duplicate_item(permission_detail);
                    if(permission_detail.indexOf('watch') > -1) {
                        $role_item.find('.role-edit').prop('disabled', false);
                    } else {
                        $role_item.find('.role-edit').prop('disabled', true);
                    }
                    $role_item.find(".checked-all").prop("checked", true);

                    role_user[`${permission}`] = permission_detail;
                } else {
                    let index = permission_detail.indexOf($(this).val());
                    let permission = $role_item.find("input.checked-all").val();
                    if(index > -1) {
                        permission_detail.splice(index,1);
                        permission_detail = plugin.remove_duplicate_item(permission_detail);
                    }
                    role_user[`${permission}`] = permission_detail;
                    if(permission_detail.indexOf('watch') > -1) {
                        $role_item.find('.role-edit').prop('disabled', false);
                    } else {
                        $role_item.find('.role-edit').prop('disabled', true);
                        $role_item.find('.role-edit').prop('checked', false);
                        $role_item.find(".checked-all").prop("checked", false);
                        delete role_user[`${permission}`];
                    }
                    if(permission_detail.length === 0) {
                        $role_item.find(".checked-all").prop("checked", false);
                        delete role_user[`${permission}`];
                    }

                }
                $element.find(`input[name="${field_name}"]`).val(JSON.stringify(role_user));

            });

        };

        plugin.remove_duplicate_item = function(names) {
            var uniqueNames = [];
            $.each(names, function(i, el){
                if($.inArray(el, uniqueNames) === -1) uniqueNames.push(el);
            });
            return uniqueNames;
        }

        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.field_rolesetup = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('field_rolesetup')) {
                var plugin = new $.field_rolesetup(this, options);
                $(this).data('field_rolesetup', plugin);
            }
        });
    }
})(jQuery);