<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model as ModelAlias;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$doc = Factory::getDocument();
$orderstatusModel= ModelAlias::getInstance('orderstatuss');
$list=$orderstatusModel->getList();
$id_by_name = $id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-orderstatus">
        <div class="wrapper-orderstatus">
            <select class="orderstatus" name="<?php echo (esc_attr($name)); ?>">
                <?php foreach ($list as $item){ ?>
                    <option <?php echo ($item->open_source_order_status_id===$value?' selected ':'') ?> value="<?php echo (esc_attr($item->open_source_order_status_id)); ?>"><?php echo (esc_html($item->name)); ?></option>
                <?php } ?>
            </select>
        </div>
    </div>
<?php
$doc->addScriptApplySelector("#$id_by_name",'field_orderstatus',array(
    "input_name"=>  $name,
),'admin/app/layouts/WooBooking/form/field/orderstatus/jquery.orderstatus.js');
