<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$args = array();
$products = wc_get_products($args);
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-opensourcelinkid">
        <div class="wrapper-field-opensourcelinkid">
            <select name="<?php echo (esc_attr($name)); ?>" required="<?php echo (esc_attr($required)) ?>"
                    class="open-source-link">
                <option value=""><?php esc_html_e('Select product','wpbookingpro') ?></option>
				<?php foreach ($products as $product) { ?>
                    <option <?php echo ($product->get_id() == $value ? ' selected ' : null) ?>
                            value="<?php echo (esc_attr($product->get_id())); ?>"><?php echo (esc_html($product->get_name())); ?></option>
				<?php } ?>
            </select>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-opensourcelinkid','field_opensourcelinkid',array(
    )
    ,'admin/app/layouts/WooBooking/form/field/opensourcelinkid/opensourcelinkid.jquery.js');