"use strict";
(function ($) {
    $.field_map = function (element, options) {
        var defaults = {
            input_name: "",
            listen_onchange_address_name: "",
            eventButton: ""
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let input_name = plugin.settings.input_name;
            simplegmaps.init({
                container: `#simplegmaps-${input_name}`,
            });
            let listen_onchange_address_name = plugin.settings.listen_onchange_address_name;
            let eventButton = plugin.settings.eventButton;
            if (listen_onchange_address_name !== "" && $(`input[name="${listen_onchange_address_name}"]`).length > 0) {
                simplegmaps.Search.init({
                    input: `input[name="${listen_onchange_address_name}"]`,
                    eventButton: `#${eventButton}`,
                    AutoComplete: true
                });
            }
            $element.find('p').on('click',function () {
                $element.find('.coodinate-map').toggleClass('show');
            })
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.field_map = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('field_map')) {
                var plugin = new $.field_map(this, options);
                $(this).data('field_map', plugin);
            }
        });
    }
})(jQuery);