<?php
use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$id_by_name = "element_field_". $name;
$name_format = str_replace(array('[', ']'), '_', $name);
$locationsModel = Model::getInstance('destinations');
$list_location = $locationsModel->getList();
$list_selected = is_array($value) ? $value : array();

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>"
         class="<?php echo (esc_attr($class)); ?> field-locations-<?php echo (esc_attr($name_format)) ?> field-locations">
        <select name="<?php echo (esc_attr($name)); ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                class="form-control list-locations">
            <option value=""> <?php esc_html_e('Select location','wpbookingpro') ?></option>
			<?php foreach ($list_location as $location) { ?>
                <option <?php echo (in_array($location->id, $list_selected) ? " selected " : "") ?>
                        value="<?php echo (esc_attr($location->id)); ?>"><?php echo (esc_html($location->address)); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-locations','field_locations',array(
    "field_name"=>  $name,
),'admin/app/layouts/WooBooking/form/field/locations/locations.jquery.js');
