<?php

use WpBookingPro\Utilities\Utility;
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$doc = Factory::getDocument();
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-gender">
        <select class="list-gender" name="<?php echo (esc_attr($name)); ?>">
            <option value=""><?php esc_html_e('Select Gender','wpbookingpro') ?></option>
            <option <?php echo($value == 'male' ? ' selected ' : '') ?> value="male"><?php esc_html_e('Male','wpbookingpro') ?></option>
            <option <?php echo($value == 'female' ? ' selected ' : '') ?> value="female"><?php esc_html_e('Female','wpbookingpro') ?></option>
        </select>
    </div>
<?php
$doc->addScriptApplySelector('.field-gender', 'field_gender', array(
), 'admin/app/layouts/WooBooking/form/field/gender/jquery.gender.js');
