<?php
use WpBookingPro\Factory;
use WpBookingProAdmin\app\helpers\AdminHelper;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$doc = Factory::getDocument();
$id_by_name = "element_field_". $name;
$images = $value;
$check_user_demo = AdminHelper::checkUserDemo();
$uploads = wp_upload_dir();

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-gallery hide-option">
        <ul class="list-image">
            <?php if($images) {?>
                <?php foreach ($images as $image) { ?>
                    <li data-id="<?php echo (esc_attr($image->id)); ?>" class="image-item">
                        <i class="far fa-trash-alt remove"></i>

                        <?php $check_image_size = AdminHelper::checkImageData($uploads['baseurl'], $image->path) ?>
                        <?php if(!$check_user_demo['is_demo']) {?>
                            <img class="image" src="<?php echo(esc_url(Factory::getRootUrlPlugin() .$image->path)); ?>">
                        <?php }else {?>
                            <?php if($check_image_size) {?>
                                <img class="image" src="<?php echo(esc_url($uploads['baseurl'].'/' .$image->path)); ?>">
                            <?php } else {?>
                                <img class="image" src="<?php echo(esc_url(Factory::getRootUrlPlugin() .$image->path)); ?>">
                            <?php } ?>

                        <?php }?>
                    </li>
                <?php } ?>
			<?php } ?>
            <li>
                <div class="upload"><i class="far fa-plus-square"></i></div>
            </li>
        </ul>
		<?php if ($enable_upload) { ?>
            <input type="file" class="upload upload-file item-image" style="display: none"/>
		<?php } else { ?>
            <div class="btn-browser-media"></div>
		<?php } ?>
        <input type="hidden" name="<?php echo (esc_attr($name_field_deleted)) ?>" class="deleted" style="display: none" value=""/>
    </div>
<?php
$doc->addScriptApplySelector('.field-gallery','field_gallery',array(
    "input_name"=>  $name,
    "name_field_deleted"=>  $name_field_deleted,
    "enable_upload"=>  (boolean)$enable_upload,
    "multiple"=>  (boolean)$multiple,
),'admin/app/layouts/WooBooking/form/field/gallery/gallery.jquery.js');