<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model as ModelAlias;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$doc = Factory::getDocument();
$employeesModel= ModelAlias::getInstance('employees');
$list_employees =$employeesModel->getList();
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$list_selected = is_array($value) ? $value : array();
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-employeeservice">
        <div class="wrapper-employeeservice">
            <select name="<?php echo (esc_attr($name)); ?>" <?php echo ($multiple ? ' multiple ' : ""); ?> class="form-control list-employeeservice">
                <option value="" disabled> <?php esc_html_e('Select employees','wpbookingpro') ?></option>
                <?php foreach ($list_employees as $employee) { ?>
                    <option <?php echo (in_array($employee->id, $list_selected) ? " selected " : "") ?>
                            value="<?php echo (esc_attr($employee->id)); ?>" ><?php echo(esc_html($employee->first_name . ' '. $employee->last_name)); ?></option>
                <?php } ?>
            </select>
        </div>
    </div>
<?php
$doc->addScriptApplySelector("#$id_by_name",'field_employeeservice',array(
    "input_name"=>  $name,
),'admin/app/layouts/WooBooking/form/field/employeeservice/jquery.employeeservice.js');
