<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model as ModelAlias;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$doc = Factory::getDocument();
$employeesModel= ModelAlias::getInstance('employees');
$list_employees =$employeesModel->getList();
$input =Factory::getInput();
$event_id = $input->getInt('id', 0);
$modelEvent = ModelAlias::getInstance('event');
$modelService = ModelAlias::getInstance('service');
if($event_id > 0) {
    $event = $modelEvent->getItem($event_id);
    $service_id = reset($event->service_id);
    $list_employee_by_service = $modelService->getListEmployee($service_id);
} else {
    $list_employee_by_service = $list_employees;
}
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$list_selected = is_array($value) ? $value : array();
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-employees">
        <div class="wrapper-employees">
            <select name="<?php echo (esc_attr($name)); ?>" <?php echo ($multiple ? ' multiple ' : ""); ?> class="form-control list-employees">
                <option value="" disabled> <?php esc_html_e('Select employees','wpbookingpro') ?></option>
                <?php foreach ($list_employees as $employee) { ?>
                    <option <?php echo esc_attr(in_array($employee->id, $list_selected) ? " selected " : "") ?>
                            value="<?php echo (esc_attr($employee->id)); ?>" <?php echo (in_array($employee->id, $list_employee_by_service) ? "" : "disabled") ?>><?php echo (esc_html($employee->first_name . ' '. $employee->last_name)); ?></option>
                <?php } ?>
            </select>
        </div>
    </div>
<?php
$doc->addScriptApplySelector("#$id_by_name",'field_employees',array(
    "input_name"=>  $name,
),'admin/app/layouts/WooBooking/form/field/employees/jquery.employees.js');
