<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingProAdmin\app\helpers\EmailHelper;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$list_email_type=EmailHelper::get_list_email_type();
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-emailtype">
        <select name="<?php echo (esc_attr($name)); ?>"
                class="form-control list-emailtype">
            <option value=""><?php esc_html_e('Select email type','wpbookingpro')?></option>
            <?php foreach ($list_email_type as $item) { ?>
                <option <?php echo (EmailHelper::check_in_array_mail_type($value) ? " selected " : "") ?>
                        value="<?php echo (esc_attr($item->type)); ?>"><?php echo (esc_html($item->description)); ?></option>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-emailtype','field_emailtype',array(
        'field_name'=> $name
),'admin/app/layouts/WooBooking/form/field/emailtype/emailtype.js');