<?php
use WpBookingPro\Factory;
use WpBookingPro\Utilities\Utility;
use WpBookingProAdmin\app\helpers\AdminHelper;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$id_by_name = "element_field_" . $name;
$data = $field->getForm()->getData();
$a_title = $data->def('name');
$fullname = ucwords($data->def('first_name') . ' ' . $data->def('last_name'));
$image = $data->def('image_location_avatar');
$a_title = Utility::clean($a_title);
$a_title = Utility::clean_all_space_to_single_space($a_title);
$arrName = explode(' ', $a_title);
$arrName = array_splice($arrName, 0, 3);
$iconImg = [];
for ($i = 0; $i < count($arrName); $i++) {
	$iconImg[] = mb_substr($arrName[$i], 0, 1, "UTF-8");
}
$iconImg = implode(" ", $iconImg);
$iconImg = strtoupper($iconImg);
$check_user_demo = AdminHelper::checkUserDemo();
$uploads = wp_upload_dir();
$check_image_size = AdminHelper::checkImageData($uploads['baseurl'], $value);
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-cover">
        <div class="wrapper-field-cover">
            <div class="header">
                <i class="far fa-plus-square upload"></i>
                <div>
                    <?php if(!$check_user_demo['is_demo']) {?>
                        <img class="img-avatar" src="<?php echo (esc_url($value ? Factory::getRootUrlPlugin().$value : Factory::getRootUrlPlugin().$default)) ?>" alt="avatar" />
                    <?php } else {?>
                        <?php if($check_image_size) {?>
                            <img class="img-avatar" src="<?php echo (esc_url($value ? $uploads['baseurl'].'/'.$value : Factory::getRootUrlPlugin().$default)) ?>" alt="avatar" />
                        <?php } else {?>
                            <img class="img-avatar" src="<?php echo (esc_url($value ? Factory::getRootUrlPlugin().$value : Factory::getRootUrlPlugin().$default)) ?>" alt="avatar" />
                        <?php } ?>

                    <?php } ?>
                </div>
                <span><?php echo ($image == "" || $image == null) ? esc_html($iconImg) : "" ?></span>
            </div>
            <p><?php echo (($a_title) ? esc_html($a_title) : esc_html($fullname)); ?></p>
            <input type="file" class="upload"  name="<?php echo (esc_attr($name)); ?>" style="display: none"/>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('admin/app/layouts/WooBooking/form/field/cover/cover.less');
$doc->addScriptApplySelector("#$id_by_name",'field_cover',array(
),'admin/app/layouts/WooBooking/form/field/cover/cover.jquery.js');
