<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$id_by_name = "element_field_". $name;
$input=Factory::getInput();
$event_id=$input->getInt('id',0);
$list_rate_from = [];
$now = date('Y-m-d H:i:s');
if($event_id > 0) {
    $modelEvent = Model::getInstance('event');
    $event=$modelEvent->getItem($event_id);
    $close_date = Factory::getDate($event->close_date);
    $rates = $event->rates;
    foreach ($rates as $rate) {
        array_push($list_rate_from, $rate->from);
    }
    if (!$close_date->getTimestamp()) {
        $close_date = clone Factory::getDate();
    }
    $close_date = $close_date->toSql();
} else {
    $close_date = null;
}

if(count((array)$list_rate_from) > 0) {
    $min_date_from = min((array)$list_rate_from);
} else {
    $min_date_from = $now;
}
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="element-field-close-date <?php echo(isset($close_date)?'hide-option':'');?>">
        <div class="wrapper-label">
            <input type="checkbox" id="closedate-ckb" name="<?php echo (esc_attr($name)); ?>" />
            <label class="closedate-label" for="closedate-ckb">
                <?php esc_html_e('Booking closes when event starts','wpbookingpro')?>
            </label>
        </div>
        <div class="option form-horizontal invisible">
            <div class="block-select-close-date">
                <label for="until-when" class="control-label"><?php esc_html_e('Closes on','wpbookingpro') ?>:</label>
                <div class="select-close-date">
                    <input type="text" id="close-date" class="form-control close-date" value="<?php echo(isset($close_date) ? $close_date : $now) ?>" />
                    <input type="hidden" name="<?php echo (esc_attr($name_close_date)); ?>" />
                </div>
            </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.element-field-close-date','field_closedate',array(
    "input_name"=>$name_close_date,
    'close_date' => isset($close_date) ? $close_date : $now,
    'min_date_from'=>$min_date_from
),'admin/app/layouts/WooBooking/form/field/closedate/closedate.jquery.js');
