<?php
use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);


$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();

$day_of_week = array(
    "monday"=>"Monday",
    "tuesday"=>"Tuesday",
    "wednesday"=>"Wednesday",
    "thursday"=>"Thursday",
    "friday"=>"Friday",
    "saturday"=>"Saturday",
    "sunday"=>"Sunday"
);
$input = Factory::getInput();


?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-calendardatetime">
        <div class="row">
            <div class="col-md-12">
                <div class="is-recurring">
                    <div class="is-recurring-item">
                        <input type="radio" name="<?php echo (esc_attr($field_name_is_recurring))?>" id="not-recurring" value="0" checked>
                        <label for="not-recurring" class="is-recurring-label">
                            <?php esc_html_e('Not repeat','wpbookingpro');?>
                        </label>
                    </div>
                    <div class="is-recurring-item">
                        <input type="radio" name="<?php echo (esc_attr($field_name_is_recurring))?>" id="recurring" value="1">
                        <label for="recurring" class="is-recurring-label">
                            <?php esc_html_e('Repeat','wpbookingpro');?>
                        </label>
                    </div>
                </div>
                <div class="input-append date form_datetime" id='datetimepicker1'>
                </div>
                <div class="block-add-recurring" style="display: none">
                    <div class="block-type-of-recurring">
                        <div class="title">
                            <h5><?php esc_html_e('Repeat','wpbookingpro');?></h5>
                        </div>
                        <div class="block-input">
                            <div class="type-recurring-item">
                                <input type="radio" id="rad-daily" name="<?php echo (esc_attr($field_name_type_recurring))?>" value="daily">
                                <label for="rad-daily" class="type-recurring-label">
                                    <?php esc_html_e('Daily','wpbookingpro');?>
                                </label>
                            </div>
                            <div class="type-recurring-item">
                                <input type="radio" id="rad-weekly" name="<?php echo (esc_attr($field_name_type_recurring))?>" value="weekly">
                                <label for="rad-weekly" class="type-recurring-label">
                                    <?php esc_html_e('Weekly','wpbookingpro');?>
                                </label>
                            </div>
                            <div class="type-recurring-item">
                                <input type="radio" id="rad-monthly" name="<?php echo (esc_attr($field_name_type_recurring))?>" value="monthly">
                                <label for="rad-monthly" class="type-recurring-label">
                                    <?php esc_html_e('Monthly','wpbookingpro');?>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="day-off-week" style="display: none" >
                        <div class="title">
                            <h5><?php esc_html_e('Day of week','wpbookingpro');?></h5>
                        </div>
                        <div class="block-input">
                            <?php foreach ($day_of_week as $key => $value) {?>
                                <label for="<?php echo (esc_attr('ckb-week-'.$key))?>">
                                    <input type="checkbox" id="<?php echo (esc_attr('ckb-week-'.$key))?>" name="<?php echo (esc_attr($field_name_day_of_week.'[]'))?>" value="<?php echo (esc_attr($key))?>"
                                    />
                                    <?php echo (esc_html($value))?>
                                </label>
                            <?php }?>
                        </div>
                    </div>
                    <div class="block-number-week-recurring" style="display: none">
                        <div class="title">
                            <h5><?php esc_html_e('Number weeks recurring','wpbookingpro');?></h5>
                        </div>
                        <div class="block-input">
                            <input type="text" name="<?php echo (esc_attr($field_name_number_week_recurring))?>" >
                        </div>
                    </div>
                    <div class="block-number-month-recurring" style="display: none">
                        <div class="title">
                            <h5><?php esc_html_e('Number months recurring','wpbookingpro');?></h5>
                        </div>
                        <div class="block-input">
                            <input type="text" name="<?php echo (esc_attr($field_name_number_month_recurring))?>">
                        </div>
                    </div>
                    <div class="block-select-allday" style="display:none;">
                        <div class="title">
                            <h5><?php esc_html_e('All day or specific day','wpbookingpro');?></h5>
                        </div>
                        <div class="block-input">
                            <div class="all-day-item">
                                <input type="radio" id="all-day-of-month" name="<?php echo (esc_attr($field_name_day_in_month))?>" value="all-day">
                                <label for="all-day-of-month" class="all-day-label">
                                    <?php esc_html_e('All day','wpbookingpro');?>
                                </label>
                            </div>
                            <div class="all-day-item">
                                <input type="radio" id="specific-day-of-month" name="<?php echo (esc_attr($field_name_day_in_month))?>" value="specific-day">
                                <label for="specific-day-of-month" class="all-day-label">
                                    <?php esc_html_e('Specific day','wpbookingpro');?>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="block-specific-day-select" style="display: none">
                        <div class="title">
                            <h5><?php esc_html_e('Specific day','wpbookingpro');?></h5>
                        </div>
                        <div class="block-input"></div>
                    </div>
                    <div class="block-set-recurring-time">
                        <div class="block-recurring-date">
                            <div class="block-left">
                                <h5><?php esc_html_e('Start recurring date','wpbookingpro');?></h5>
                                <div class="datetimepiker">
                                    <input type="text" class="date-start-recurring">
                                </div>

                            </div>
                            <div class="block-right">
                                <h5><?php esc_html_e('Start recurring time','wpbookingpro');?></h5>
                                <input type="text" class="time-start-recurring">
                            </div>
                        </div>
                        <div class="block-recurring-date">
                            <div class="block-left">
                                <h5><?php esc_html_e('End recurring date','wpbookingpro');?></h5>
                                <input type="text" class="date-end-recurring">
                            </div>
                            <div class="block-right">
                                <h5><?php esc_html_e('End recurring time','wpbookingpro');?></h5>
                                <input type="text" class="time-end-recurring" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="comment-addition">
                        <h5><?php esc_html_e('Description','wpbookingpro');?></h5>
                        <textarea name="<?php echo (esc_attr($field_name_comment_addition))?>" cols="30" rows="10"></textarea>
                    </div>
                </div>
                <input type="hidden" class="mirror_field" name="<?php echo (esc_attr($name));?>">
                <input type="hidden" name="<?php echo (esc_attr($field_name_date_start_recurring));?>">
                <input type="hidden" name="<?php echo (esc_attr($field_name_time_start_recurring));?>">
                <input type="hidden" name="<?php echo (esc_attr($field_name_date_end_recurring));?>">
                <input type="hidden" name="<?php echo (esc_attr($field_name_time_end_recurring));?>">
            </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();

$doc->addScriptApplySelector('.field-calendardatetime','field_calendardatetime',array(
    "field_name"=>  $name,
    "field_name_date_start_recurring"=>$field_name_date_start_recurring,
    "field_name_time_start_recurring"=>$field_name_time_start_recurring,
    "field_name_date_end_recurring"=>$field_name_date_end_recurring,
    "field_name_time_end_recurring"=>$field_name_time_end_recurring,
    "field_name_is_recurring"=>$field_name_is_recurring,
    "field_name_type_recurring"=>$field_name_type_recurring,
    "field_name_number_week_recurring"=>$field_name_number_week_recurring,
    "field_name_number_month_recurring"=>$field_name_number_month_recurring,
    "field_name_day_in_month"=>$field_name_day_in_month,
),'admin/app/layouts/WooBooking/form/field/calendardatetime/calendardatetime.js');