<?php

use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$doc = Factory::getDocument();
$id_by_name = "element_field_". $name;

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-birthday">
        <div class="row">
            <div class="col-md-12">
                <div class="input-group">
                    <input type="text" class="birthday" id="birthday" value="<?php echo (esc_attr(isset($value)?$value:''))?>">
                    <i class="far fa-calendar-alt"></i>
                    <input type="hidden" name="<?php echo (esc_attr($name));?>" value="<?php echo (esc_attr(isset($value)?$value:''))?>">
                </div>
            </div>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.field-birthday', 'field_birthday', array(
    "input_name" => $name,
), 'admin/app/layouts/WooBooking/form/field/birthday/jquery.birthday.js');
