<?php
namespace WpBookingProAdmin\app\helpers;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model as ModelAlias;
use WpBookingPro\Mvc\Table\Table;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;

class ConfigHelper extends AdminHelper
{
    public static function set_page_appointment($page_id,$type){
        $modelConfig = ModelAlias::getInstance('config');
        $table = $modelConfig->getTable();
        $table->load(1);
        $params = $table->params;
        $reg = new Registry();
        $reg->loadString($params);
        $reg->set($type,$page_id);
        $table->params = $reg->toString();
        $table->store();
    }
    public static function get_page_list_service(){
        $modelConfig = ModelAlias::getInstance('config');
        $item = $modelConfig->getItem(1);
        return $item->params->get('page_list_service',0);

    }
    public static function get_page_list_category(){
        $modelConfig = ModelAlias::getInstance('config');
        $item = $modelConfig->getItem(1);
        return $item->params->get('page_list_category',0);

    }
    public static function get_page_list_employee(){
        $modelConfig = ModelAlias::getInstance('config');
        $item = $modelConfig->getItem(1);
        return $item->params->get('page_list_employee',0);

    }
    public static function get_page_service_detail(){
        $modelConfig = ModelAlias::getInstance('config');
        $item = $modelConfig->getItem(1);
        return $item->params->get('page_service_detail',0);

    }

    public static function create_create_page($view,$type)
    {
        $a_view=str_replace("-"," ",$view);
        $key_page=$a_view;
        $appointment_detail = array(
            'post_name' => "$key_page",
            'post_title' => $key_page,
            'post_content' => '[wpbookingpro view="'.$view.'"]',
            'post_status' => "publish",
            'post_author' => get_current_user_id(),
            'post_type' => "page",
        );
        $post_id=wp_insert_post($appointment_detail, '');
        self::set_page_appointment($post_id,$type);
    }

}