"use strict";
(function ($) {
    $.view_list_user = function (element, options) {
        let defaults = {
            row_user_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('#example').DataTable({
                drawCallback: function () {
                    $element.find('input[type="checkbox"]').iCheck({
                        checkboxClass: 'icheckbox_square-red',
                        radioClass: 'iradio_square-red',
                        increaseArea: '10%'
                    });
                }
            });
            $element.find('input[type="checkbox"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            });

            $element.find('select.list-role').select2();
            $element.find('select.list-role').on('change', function () {
                let role_user_new = $(this).val();
                let $tr = $(this).closest('tr');
                let user_wp_id = $tr.data('user_wp_id');
                let data = {
                    role_user_new: role_user_new,
                    user_wp_id: user_wp_id,
                    task: "user.ajax_change_role_user_wordpress"
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: data,
                    beforeSend: function () {
                        $('body').loadingModal();
                    },
                    error: function (xhr) {
                        $.alert({
                            title: 'Error',
                            content: 'there are some error please contact admin !',
                        });
                    },
                    complete: function () {
                        $('body').loadingModal('destroy');
                    },
                    success: function (response) {
                    }
                });
            });

        };
        plugin.example_function = function () {
        };
        plugin.init();
    };
    $.fn.view_list_user = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_user')) {
                let plugin = new $.view_list_user(this, options);
                $(this).data('view_list_user', plugin);
            }
        });
    }
})(jQuery);
