<?php
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Utilities\Utility;


$id_by_name = "element_field_". $customize->field_name;
$name_of_field = str_replace(array('[', ']'), '_', $customize->field_name);
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-boolean">
        <div class="form-control">
            <div class="block-left">
                <label><?php esc_html_e($customize->label_field,'wpbookingpro') ?></label>
                <span class="tooltipster" class="fas fa-question-circle"></span>
            </div>
            <div class="block-right">
                <input class="form-check-input yes-no pull-right" <?php echo (isset($customize->value) && $customize->value == 1 ? ' checked ' : "unchecked") ?>
                       type="checkbox">
                <input class="" name="<?php echo(esc_attr($customize->field_name)); ?>" type="hidden"
                       value="<?php echo (esc_attr($customize->value)) ?>">
            </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('#'.$id_by_name,'field_boolean',array(
    "field_name"=>  $customize->field_name,
), 'admin/app/HtmlCustomField/hmtl/boolean/boolean.jquery.js');